﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja wyjść prywatnych</title>
		<script runat="server">
		        
	   class Item {

           public Pracownik pracownik;
           public Pracownik Pracownik {
               get { return pracownik; }
           }
           
			readonly string nazwa;
			readonly protected object[] items = new object[12];
			
			public Item(string nazwa) {
				this.nazwa = nazwa;
			}
			public void Set(int m, object value) {
				items[m-1] = value;
			}
			public string Nazwa {
				get { return nazwa; }
			}
			public object M1 {
				get { return items[0]; }
			}
			public object M2 {
				get { return items[1]; }
			}
			public object M3 {
				get { return items[2]; }
			}
			public object M4 {
				get { return items[3]; }
			}
			public object M5 {
				get { return items[4]; }
			}
			public object M6 {
				get { return items[5]; }
			}
			public object M7 {
				get { return items[6]; }
			}
			public object M8 {
				get { return items[7]; }
			}
			public object M9 {
				get { return items[8]; }
			}
			public object M10 {
				get { return items[9]; }
			}
			public object M11 {
				get { return items[10]; }
			}
			public object M12 {
				get { return items[11]; }
			}
			public virtual object MR { 
				get { return ""; }
			}
	   }
	   
	   class IntItem: Item {
			public IntItem(string nazwa): base(nazwa) {
				for (int i=0; i<12; i++)
					items[i] = 0;
			}
			public override object MR { 
				get {
					int razem = 0;
					foreach (int i in items)
						razem += i;
					return razem;
				}
			}
			public void Add(int m, int v) {
				items[m-1] = (int)items[m-1] + v;
			}
	   }
	   
	   class TimeItem: Item {
			public TimeItem(string nazwa): base(nazwa) {
				for (int i=0; i<12; i++)
					items[i] = Time.Zero;
			}
			public override object MR { 
				get {
					Time razem = Time.Zero;
					foreach (Time i in items)
						razem += i;
					return razem;
				}
			}
			public void Add(int m, Time t) {
				items[m-1] = (Time)items[m-1] + t;
			}
	   }
	   
	   public class PrnParams: ContextBase {
	   
		   public PrnParams(Context context): base(context) {
			   Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			   okres = FromTo.Year(data.Year);
		   }
		   
		   FromTo okres;
		   [Required]
		   [Priority(1)]
		   public FromTo Okres {
			   get { return okres; }
			   set {
				   okres = value;
				   OnChanged(EventArgs.Empty);
			   }
		   }

		   bool tylkoNiezbilansowane = false;
		   [Priority(2)]
		   [Caption("Tylko niezbilansowane")]
		   public bool TylkoNiezbilansowane {
			   get { return tylkoNiezbilansowane; }
			   set {
				   tylkoNiezbilansowane = value;
				   OnChanged(EventArgs.Empty);
			   }
		   }
	   }

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }

            //static bool infoOCzasiePracy = false;
            bool infoOCzasiePracy = false;
            [Priority(1)]
            [Caption("Info o czasie pracy")]
            public bool InfoOCzasiePracy {
                get { return infoOCzasiePracy; }
                set {
                    infoOCzasiePracy = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
		              
        PrnParams pars;
        [Context(Required=true)]
        public PrnParams Params {
            get { return pars; }
            set { pars = value; }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }		
		            
       void OnContextLoad(Object sender, EventArgs args) {
			Row[] rows = (Row[])dc[typeof(Row[])];            
			
           ArrayList items = new ArrayList();
           foreach (Pracownik idx in rows)
               items.AddRange(WyliczPracownika(idx));

           if (pars.Okres == FromTo.Year(pars.Okres.From.Year))
               ReportHeader1["OKRES"] = pars.Okres.From.Year + " rok";
           else
               ReportHeader1["OKRES"] = pars.Okres.ToString();		
           ReportHeader1["NIEROZL"] = pars.TylkoNiezbilansowane ? "TAK" : "NIE";
           
           Grid2.DataSource = items;
	    }
    
		static readonly string prefix = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

        ArrayList WyliczPracownika(Pracownik pracownik) {
			ArrayList items2 = new ArrayList();
			
			IntItem normaD = new IntItem("Normatywny czas pracy - dni");
			TimeItem normaT = new TimeItem(prefix + "- godziny");
			
			IntItem pracaD = new IntItem("Faktyczny czas pracy - dni");
			TimeItem pracaT = new TimeItem(prefix + "- godziny");

            if (srpars.InfoOCzasiePracy) {
                items2.Add(normaD);
                items2.Add(normaT);
                items2.Add(pracaD);
                items2.Add(pracaT);
            }

            TimeItem rozliczane = new TimeItem("Wyjścia prywatne do rozliczenia");
            items2.Add(rozliczane);
            TimeItem rozliczone = new TimeItem(prefix + "rozliczone");
            items2.Add(rozliczone);
            TimeItem saldo = new TimeItem(prefix + "Pozostało do rozliczenia");
            items2.Add(saldo);
           													
			Hashtable ht = new Hashtable();

            FromTo okres = pars.Okres;
            Periods zatrud = Periods.Empty;
            Periods wgkalendarza = Periods.Empty;

            foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres)) {
                zatrud += ph.Etat.EfektywnyOkres;
                if (ph.Etat.InterpretacjaKalendarza != InterpretacjaKalendarza.WgZestawien)
                    wgkalendarza += ph.Etat.EfektywnyOkres;
            }

            zatrud = zatrud.ToFlat();
            zatrud *= okres;
            zatrud = zatrud.BreakByMonth();

            Soneta.Kalend._Pracownik.CzasPracyEtatWorker worker = new Soneta.Kalend._Pracownik.CzasPracyEtatWorker();
            worker.Pracownik = pracownik;

            foreach (FromTo okr in zatrud) {
                worker.Okres = okr;
                int m = okr.From.Month;

                CzasDni norma = worker.Norma;
                normaD.Add(m, norma.Dni);
                normaT.Add(m, norma.Czas);

                CzasDni praca = worker.Praca;
                pracaD.Add(m, praca.Dni);
                pracaT.Add(m, praca.Czas);

                if (wgkalendarza.Contains(okr)) {
                    Soneta.Kalend._Pracownik.CzasPracyBaseWorker.WgStrefLista sl = worker.WgStref;
                    Time t1 = sl["Rozliczenie wyjścia prywatnego"].Czas;
                    Time t2 = sl["Wyjście prywatne"].Czas;
                    Time t3 = (t1 != Time.Empty || t2 != Time.Empty) ? (t2 == Time.Empty ? Time.Zero : t2) - (t1 == Time.Empty ? Time.Zero : t1) : Time.Empty;
                    rozliczane.Add(m, t2);
                    rozliczone.Add(m, t1);
                    saldo.Add(m, t3);
                }
            }            			
            
            foreach (Item item in items2)
                item.pracownik = pracownik;

            if (pars.TylkoNiezbilansowane && saldo.MR.Equals(Time.Zero))
                items2.Clear();
            else if (rozliczone.MR.Equals(Time.Zero) && rozliczane.MR.Equals(Time.Zero))
                items2.Clear();
           return items2;
       }
    
       public static void Msg(object obj) {
       }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="EwidencjaCzasuPracy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
				<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" 
				title="Ewidencja wyjść prywatnych&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Wydział:&lt;strong&gt; {0}&lt;BR&gt;&lt;/strong&gt;Pośrednio:&lt;strong&gt; {1}&lt;BR&gt;&lt;/strong&gt;Okres:&lt;strong&gt; {2}&lt;BR&gt;&lt;/strong&gt;Aktualny:&lt;strong&gt; {3}&lt;BR&gt;&lt;/strong&gt;Raport za okres:&lt;strong&gt; %OKRES%&lt;BR&gt;&lt;/strong&gt;Tylko niezbilansowane:&lt;strong&gt; %NIEROZL%&lt;/SPAN&gt;" 
                DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny">
                </cc1:reportheader>
				<ea:grid id="Grid2" runat="server" DataMember="DataSource" 
                GroupData0="Pracownik" GroupLine="{0}">
					<Columns>
						<ea:GridColumn Width="30" DataMember="Nazwa" Caption=" "></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M1" Caption="I" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M2" Caption="II" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M3" Caption="III" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M4" Caption="IV" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M5" Caption="V" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M6" Caption="VI" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M7" Caption="VII" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M8" Caption="VIII" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M9" Caption="IX" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M10" Caption="X" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M11" Caption="XI" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="M12" Caption="XII" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Width="8" Align="Right" DataMember="MR" Caption="Razem" HideZero="True"></ea:GridColumn>
					</Columns>
				</ea:grid>
			</ea:datarepeater></form>
	</body>
</HTML>
